<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Uploaded Photos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Fredoka:wght@400;600&display=swap" rel="stylesheet">
    <link href="./assets/view_styles.css" rel="stylesheet">
</head>
<body>
    <div class="container">
        <h1 class="text-center mb-4 mt-4">📸 Uploaded Photos</h1>

        <?php if (empty($files)): ?>
            <p class="text-center text-dark fs-5">No photos uploaded yet.</p>
        <?php else: ?>
            <div class="text-center mb-4">
                <a href="download" class="btn btn-success">Download All Photos</a>
            </div>
            <div class="row g-4">
                <?php foreach ($files as $file): ?>
                    <div class="col-12 col-sm-6 col-md-4 col-lg-3">
                        <div class="photo-card">
                            <img src="<?php echo htmlspecialchars('./upload/' . $file); ?>" alt="<?php echo htmlspecialchars($file); ?>" loading="lazy" data-bs-toggle="modal" data-bs-target="#photoModal" data-image="<?php echo htmlspecialchars('./upload/' . $file); ?>">
                            <div class="card-body d-flex flex-column">
                                <h5 class="card-title"><?php echo htmlspecialchars($file); ?></h5>
                                <div class="mt-auto text-center">
                                    <form method="post" action="photos" class="delete-form" onclick="event.stopPropagation()">
                                        <input type="hidden" name="delete" value="<?php echo htmlspecialchars($file); ?>">
                                        <button type="submit" class="btn btn-danger btn-sm" onclick="event.stopPropagation()">Delete</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>

    <!-- Bootstrap Modal for Full Size Image -->
    <div class="modal fade" id="photoModal" tabindex="-1" aria-labelledby="photoModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
          <div class="modal-body text-center">
            <img src="" id="modalImage" alt="Full size photo">
          </div>
        </div>
      </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="./assets/view_script.js"></script>
    <script>currentFiles = new Set(<?php echo json_encode($files); ?>);</script>
</body>
</html>
