<?php

class ViewController {

    public function handleDelete() {

        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete'])) {

            $fileToDelete = basename($_POST['delete']);

            $filePath = '../upload/' . $fileToDelete;

            if (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {

                // AJAX request

                if (file_exists($filePath)) {

                    unlink($filePath);

                    echo json_encode(['status' => 'success']);

                } else {

                    echo json_encode(['status' => 'error', 'message' => 'File not found']);

                }

                exit;

            } else {

                // Regular request

                if (file_exists($filePath)) {

                    unlink($filePath);

                    echo "<div class='alert alert-success text-center'>File '$fileToDelete' deleted successfully.</div>";

                } else {

                    echo "<div class='alert alert-danger text-center'>File '$fileToDelete' not found.</div>";

                }

            }

        }

    }

    public function getFiles() {

        $uploadDir = '../upload/';

        $files = [];

        if (is_dir($uploadDir)) {

            $files = array_diff(scandir($uploadDir), array('.', '..'));

            // Sort files by modification time, newest first

            usort($files, function($a, $b) use ($uploadDir) {

                return filemtime($uploadDir . $b) - filemtime($uploadDir . $a);

            });

        }

        return $files;

    }

}

?>
