<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Access-Control-Allow-Headers: Content-Type');

error_log('Upload request received');

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    echo json_encode(['status' => 'endpoint working']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['file'])) {
    $filename = $_FILES['file']['name'];
    $uploadDir = '../upload/';
    $uploadPath = $uploadDir . $filename;

    error_log('File received: ' . $filename . ', size: ' . $_FILES['file']['size'] . ', error: ' . $_FILES['file']['error']);

    // Ensure upload directory exists
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
        error_log('Created upload directory');
    }

    // Move uploaded file
    if (move_uploaded_file($_FILES['file']['tmp_name'], $uploadPath)) {
        error_log('File saved successfully: ' . $uploadPath);
        http_response_code(200);
        $fullUrl = '/arv3/upload/' . $filename;
        echo json_encode(['status' => 'success', 'filename' => $filename, 'url' => $fullUrl]);
    } else {
        error_log('Failed to save file, error code: ' . $_FILES['file']['error']);
        http_response_code(500);
        echo json_encode(['status' => 'error', 'message' => 'Failed to save file']);
    }
} else {
    error_log('No file uploaded or not POST');
    http_response_code(400);
    echo json_encode(['error' => 'No file uploaded']);
}
?>
