<?php
$uploadDir = '../upload/';

if (!is_dir($uploadDir)) {
    die('Upload directory not found.');
}

$files = array_diff(scandir($uploadDir), array('.', '..'));

if (empty($files)) {
    die('No files to download.');
}

$zip = new ZipArchive();
$zipFile = tempnam(sys_get_temp_dir(), 'photos');

if ($zip->open($zipFile, ZipArchive::CREATE) !== TRUE) {
    die('Could not create zip file.');
}

foreach ($files as $file) {
    $filePath = $uploadDir . $file;
    if (is_file($filePath)) {
        $zip->addFile($filePath, $file);
    }
}

$zip->close();

header('Content-Type: application/zip');
header('Content-Disposition: attachment; filename="all_photos.zip"');
header('Content-Length: ' . filesize($zipFile));

readfile($zipFile);
unlink($zipFile);
?>
