// Show full-size image in modal when clicked
const photoModal = document.getElementById('photoModal');
photoModal.addEventListener('show.bs.modal', event => {
    const trigger = event.relatedTarget;
    const imageSrc = trigger.getAttribute('data-image');
    const modalImage = document.getElementById('modalImage');
    modalImage.src = imageSrc;
});

// Handle delete via AJAX
document.addEventListener('submit', function(e) {
    if (e.target.classList.contains('delete-form')) {
        e.preventDefault();
        if (!confirm('Are you sure you want to delete this photo?')) return;
        const formData = new FormData(e.target);
        fetch('photos', {
            method: 'POST',
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: formData
        }).then(response => response.json()).then(data => {
            if (data.status === 'success') {
                e.target.closest('.col-lg-3').remove();
                currentFiles.delete(formData.get('delete'));
            } else {
                alert('Delete failed: ' + data.message);
            }
        }).catch(error => {
            console.error('Error deleting:', error);
        });
    }
});

// Poll for new photos every 10 seconds and add them dynamically
let currentFiles = new Set();

setInterval(async function() {
    try {
                const response = await fetch('./get_files.php');
        const data = await response.json();
        const newFiles = data.files.filter(file => !currentFiles.has(file));
        newFiles.forEach(file => {
            currentFiles.add(file);
            addPhotoCard(file);
        });
    } catch (error) {
        console.error('Error fetching new files:', error);
    }
}, 10000);

function addPhotoCard(file) {
    const row = document.querySelector('.row.g-4');
    const col = document.createElement('div');
    col.className = 'col-12 col-sm-6 col-md-4 col-lg-3';
    col.innerHTML = `
        <div class="photo-card">
            <img src="../upload/${file}" alt="${file}" loading="lazy" data-bs-toggle="modal" data-bs-target="#photoModal" data-image="../upload/${file}">
            <div class="card-body d-flex flex-column">
                <h5 class="card-title">${file}</h5>
                <div class="mt-auto text-center">
                    <form method="post" action="photos" class="delete-form" onclick="event.stopPropagation()">
                        <input type="hidden" name="delete" value="${file}">
                        <button type="submit" class="btn btn-danger btn-sm" onclick="event.stopPropagation()">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    `;
    row.insertBefore(col, row.firstChild);
}
